﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>


<script runat="server">

    public class Params : ContextBase
    {
        public Params(Context context) : base(context)
        {
            var obj = LoadProperty(DokumentyST.UstawienieTechniczneWylaczenieSprawdzaniaStanuDokumentu, DokumentyST.KategoriaUstawienTechnicznych);
            wylSprawdzaniaStanu = obj != null && (bool) obj;
        }


        private bool wylSprawdzaniaStanu;


        [Caption("Wył. sprawdz. st. dok.")]
        public bool UstawienieTechniczneWylaczenieSprawdzaniaStanuDokumentu
        {
            get { return wylSprawdzaniaStanu; }
            set
            {
                wylSprawdzaniaStanu = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }


    [Context]
    public Params Pars { get; set; }

   

    private void dc_ContextLoad(object sender, EventArgs e)
    {
        var obj = Pars.LoadProperty(DokumentyST.UstawienieTechniczneWylaczenieSprawdzaniaStanuDokumentu, DokumentyST.KategoriaUstawienTechnicznych);
        var wylSprawdzaniaStanu = obj != null && (bool) obj;

        if (Pars.UstawienieTechniczneWylaczenieSprawdzaniaStanuDokumentu == wylSprawdzaniaStanu)
            throw new Exception("Nie zmieniono ustawienia - identyczne z aktualnym");

        Pars.SaveProperty(DokumentyST.UstawienieTechniczneWylaczenieSprawdzaniaStanuDokumentu, DokumentyST.KategoriaUstawienTechnicznych);
        throw new CancelException();
    }

</script>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Weryfikacja stanu dokumentu</title>
</head>
<body>
<form method="post" runat="server">
    <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
</form>
</body>
</html>

